<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Connectors;

class ExchangeAuthCodeResponse extends \Google\Model
{
  /**
   * @var AccessCredentials
   */
  public $accessCredentials;
  protected $accessCredentialsType = AccessCredentials::class;
  protected $accessCredentialsDataType = '';

  /**
   * @param AccessCredentials
   */
  public function setAccessCredentials(AccessCredentials $accessCredentials)
  {
    $this->accessCredentials = $accessCredentials;
  }
  /**
   * @return AccessCredentials
   */
  public function getAccessCredentials()
  {
    return $this->accessCredentials;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ExchangeAuthCodeResponse::class, 'Google_Service_Connectors_ExchangeAuthCodeResponse');
